const { Kafka } = require("kafkajs");
const mysql = require("mysql2/promise");

const kafka = new Kafka({
  clientId: "mondfx-consumer",
  brokers: ["172.86.66.23:29092"],
});

const topic = "tron.deposit.event";

async function run() {
  const db = await mysql.createConnection({
    host: "localhost",
    user: "root",
    password: "StrongPass@123",
    database: "swagger",
  });

  console.log("✅ MySQL connected");

  const consumer = kafka.consumer({ groupId: "mondfx-consmer" });
  await consumer.connect();
  await consumer.subscribe({ topic, fromBeginning: false });

  console.log(`🚀 Subscribed to topic: ${topic}`);

  await consumer.run({
    eachMessage: async ({ message }) => {
      const raw = message.value.toString();

      try {
        const data = JSON.parse(raw);
        console.log("📥 Incoming:", data);

        const [exists] = await db.execute(
          "SELECT id FROM kafka_messages WHERE tx_id = ?",
          [data.TxId]
        );

        if (exists.length) {
          console.log("⚠️ Duplicate. Skipping...");
          return;
        }

        await db.execute(
          `INSERT INTO kafka_messages 
            (from_address, to_address, amount, tx_id, processed, created_at, updated_at)
           VALUES (?, ?, ?, ?, false, NOW(), NOW())`,
          [data.From, data.To, data.Amount, data.TxId]
        );

        console.log("💾 Inserted:", data.TxId);
      } catch (err) {
        console.error("❌ Error:", err.message);
      }
    },
  });
}

run().catch((err) => {
  console.error("❌ Fatal:", err.message);
});
